#include <iostream>
#include <vector>
#include <utility>

#define CR const&

using namespace std;

long long MaxSuma(vector<pair<int, int>> CR linije) {
    long long max = 0;
    for (auto& l : linije) {
        max += l.second;
    }
    return max;
}

void Popuni(vector<vector<int>>& polje, vector<pair<int, int>>& redovi, vector<pair<int, int>>& kolone) {
    for (auto& k : kolone) {
        k.second -= k.first;
    }
    int i = 0;
    int j = 0;
    while (i < polje.size() && j < polje[i].size()) {
        while (redovi[i].second > 0 && j < polje[i].size()) {
            int v = min(kolone[j].first, redovi[i].second);
            polje[i][j] += v;
            redovi[i].second -= v;
            kolone[j].first -= v;
            j += redovi[i].second > 0;
        }
        i += j < polje[i].size();
    }
    j = 0;
    for (; i < polje.size() && j < polje[i].size(); ++i) {
        while (redovi[i].second > 0) {
            int v = min(kolone[j].second, redovi[i].second);
            polje[i][j] += v;
            redovi[i].second -= v;
            kolone[j].second -= v;
            j += redovi[i].second > 0;
        }
    }
}
void Popuni2(vector<vector<int>>& polje, vector<pair<int, int>>& redovi, vector<pair<int, int>>& kolone) {
    for (auto& r : redovi) {
        r.second -= r.first;
    }
    int i = 0;
    int j = 0;
    while (i < polje[j].size() && j < polje.size()) {
        while (kolone[i].second > 0 && i < polje[j].size()) {
            int v = min(redovi[j].first, kolone[i].second);
            polje[i][j] += v;
            kolone[i].second -= v;
            redovi[j].first -= v;
            i += kolone[i].second > 0;
        }
        j += i < polje[j].size();
    }
    i = 0;
    for (; i < polje.size() && j < polje[i].size(); ++i) {
        while (kolone[i].second > 0 && i < polje[j].size()) {
            int v = min(redovi[j].second, kolone[i].second);
            polje[i][j] += v;
            kolone[i].second -= v;
            redovi[j].second -= v;
            i += kolone[i].second > 0;
        }
    }
}

vector<pair<pair<int, int>, int>> Sadnice(vector<vector<int>> CR polje) {
    vector<pair<pair<int, int>, int>> out;
    for (int i = 0; i < polje.size(); ++i) {
        for (int j = 0; j < polje[i].size(); ++j) {
            if (polje[i][j] != 0) {
                out.push_back({ { i + 1, j + 1 }, polje[i][j] });
            }
        }
    }
    return out;
}

void OptimiseIO() {
    ios_base::sync_with_stdio(false);
    cout.tie(0);
    cerr.tie(0);
    cin.tie(0);
}

int main() {
    OptimiseIO();
    int n;
    int m;
    cin >> n >> m;
    vector<pair<int, int>> redovi(n);
    vector<pair<int, int>> kolone(m);
    for (auto& r : redovi) {
        cin >> r.first >> r.second;
    }
    for (auto& k : kolone) {
        cin >> k.first >> k.second;
    }
    cout << endl;
    long long poRedovima = MaxSuma(redovi);
    long long poKolonama = MaxSuma(kolone);
    long long najvise = min(poRedovima, poKolonama);
    cout << najvise << endl;
    vector<vector<int>> polje(n, vector<int>(m, 0));
    if (najvise = poRedovima) {
        Popuni(polje, redovi, kolone);
    }
    else {
        Popuni2(polje, redovi, kolone);
    }
    redovi.clear();
    kolone.clear();
    auto sadnice = Sadnice(polje);
    cout << sadnice.size() << endl;
    for (auto& s : sadnice) {
        cout << s.first.first << ' ' << s.first.second << ' ' << s.second << endl;
    }
    return 0;
}